<?php
require_once SCRIPT_PATH . 'Signature.php';

abstract class Base {
    
    /**
     *
     * Important data such as 'Keywords'
     * @var string
     */
    protected $_data;
    
    /**
     *
     * Amazon_Signature object
     * @var Amazon_Signature
     */
    protected $_signature;
    
    /**
     *
     * Set data
     * 
     * @access public
     * @param string $data 
     * @return void
     */
    public function setData( $data ) {
        
        $data = trim($data);
        if( !empty($data) ) {
            $this->_data = $data;
        }
        
    }
    
    /**
     *
     * Set Amazon_Signature object
     * 
     * @access public
     * @param Amazon_Signature $signature 
     * @return void
     */
    public function setSignature(Signature $signature) {
        $this->_signature = $signature;
    }
    
}

